{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 26.03.98 - 18:26:52 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  ExtCtrls,
  Menus,
  MMAbout,
  MMUtils,
  MMCCon,
  MMDesign,
  MMObj,
  MMPanel,
  MMWheel,
  MMButton,
  MMBmpLst,
  MMBmpBtn,
  MMHook,
  MMFill,
  MMLEDS,
  MMDIBCv,
  MMLevel,
  MMHTimer,
  MMPCXTol,
  MMPCXCtl,
  MMSlider,
  MMPCX;

type
  TForm1 = class(TForm)
    MMDesigner1: TMMDesigner;
    PCXConnector: TMMPCXConnector;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Time1: TMenuItem;
    About1: TMenuItem;
    menOpen: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    OpenDialog: TOpenDialog;
    menRemaining: TMenuItem;
    menElapsed: TMenuItem;
    MMPanel1: TMMPanel;
    MMBitmapList1: TMMBitmapList;
    btnStop: TMMBitmapButton;
    btnPlay: TMMBitmapButton;
    btnPause: TMMBitmapButton;
    MMFormFill1: TMMFormFill;
    ledMode: TMMLEDMode;
    MMLevelScale1: TMMLevelScale;
    digit: TMMLEDDigit;
    MMLevel2: TMMLevel;
    MMLevel1: TMMLevel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    ss: TMMLEDDigit;
    ss2: TMMLEDDigit;
    mm: TMMLEDDigit;
    mm2: TMMLEDDigit;
    Gauge: TMMLevel;
    lblBitRate: TLabel;
    lblLayer: TLabel;
    lblLayer2: TLabel;
    ledBitRate: TMMLEDPanel;
    Timer1: TMMHiTimer;
    PCXPipe: TMMPCXPipe;
    OutputStream: TMMPCXOutputStream;
    PCXCard: TMMPCXCard;
    procedure menOpenClick(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure menElapsedClick(Sender: TObject);
    procedure menRemainingClick(Sender: TObject);
    procedure btnPauseClick(Sender: TObject);
    procedure btnPlayClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure PCXStreamNotify(Sender: TObject; Reason: TMMPCXNotify);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Timer1Timer(Sender: TObject);
  private
    StartPos: Longint;
    procedure   CreateParams(var Params: TCreateParams); override;

  public
    procedure SetFileParams;

  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.CreateParams(var Params: TCreateParams);
begin
   inherited CreateParams(Params);
   Params.Style := Params.Style and not WS_SIZEBOX;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.FormCreate(Sender: TObject);
begin
   { allocate the Pipe }
   PCXPipe.Allocate;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   btnStopClick(nil);
   { release the Pipe }
   PCXpipe.Release;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.SetFileParams;
begin
   with OutputStream.Format do
   begin
      if (FileFormat <> ftWAV) then
      begin
         lblLayer.Visible := True;
         lblLayer2.Visible:= True;
         case MPEGLayer of
             mLayer1: lblLayer2.Caption := 'I';
             mLayer2: lblLayer2.Caption := 'II';
         end;

         ledBitRate.Value := MPEGBitRate;
         ledBitRate.Visible := True;
         lblBitRate.Visible := True;
      end
      else
      begin
         lblLayer.Visible  := False;
         lblLayer2.Visible := False;
         ledBitRate.Visible:= False;
         lblBitRate.Visible := False;
      end;

      ledMode.Mode := Mode;
      ledMode.Visible := True;
   end;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.menOpenClick(Sender: TObject);
begin
   if OpenDialog.Execute then
   begin
      OutputStream.FileName := OpenDialog.FileName;
      btnPlay.Enabled := True;
      SetFileParams;
   end;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.Exit1Click(Sender: TObject);
begin
   Close;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.menRemainingClick(Sender: TObject);
begin
   menElapsed.Checked := False;
   menRemaining.Checked := True;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.menElapsedClick(Sender: TObject);
begin
   menRemaining.Checked := False;
   menElapsed.Checked := True;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.About1Click(Sender: TObject);
begin
   Show_AboutBox(0);
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.PCXStreamNotify(Sender: TObject; Reason: TMMPCXNotify);
begin
   case Reason of
       nBeforeEndStream: ;
       nBeginFile      : begin
                            menOpen.Enabled := False;
                            btnPlay.Down := True;
                            btnPause.Enabled := True;
                            btnStop.Enabled := True;
                            Timer1.Enabled := True;
                         end;
       nCloseFile      : begin
                            menOpen.Enabled := True;
                            Timer1.Enabled := False;
                            btnPlay.Down    := False;
                            btnPause.Enabled := False;
                            btnStop.Enabled := False;
                            PCXPipe.Stop;
                         end;
       nEndFile        : ;
   end;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.btnPlayClick(Sender: TObject);
begin
   if (PCXPipe.Status = psPaused) then
   begin
      btnPause.Down := False;
      PCXPipe.Pause(False);
   end
   else if (PCXPipe.Status = psStopped) then
   begin
      btnPlay.Down := True;

      OutputStream.Prepare(0,PLAY_ALL_FILE);

      OutputStream.Play;

      PCXPipe.Start;
   end
   else btnPlay.Down := True;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.btnPauseClick(Sender: TObject);
begin
   if (PCXPipe.Status = psPaused) then
   begin
      btnPause.Down := False;
      PCXPipe.Pause(False);
   end
   else
   begin
      btnPause.Down := True;
      PCXPipe.Pause(True);
   end;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.btnStopClick(Sender: TObject);
begin
   OutputStream.Stop;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.Timer1Timer(Sender: TObject);
Var
   Elapsed,Remaining: DWORD;
   Hour, Min, Sec, MSec: Word;

begin
   OutputStream.Position(Elapsed, Remaining);

   if menElapsed.Checked then
      TimeDecode(Elapsed, Hour, Min, Sec, MSec)
   else
      TimeDecode(Remaining, Hour, Min, Sec, MSec);

   ss.Value := Sec;
   mm.Value := Min;
end;

end.
